﻿<!--
  fileType 기본 예제입니다.
  서버에 맞게 수정해서 사용하세요.
-->
<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="java.util.*, javax.servlet.*, com.ibleaders.utility.ib_json.*"%>

<%!
  public String getFilename(Part part) {
    for (String cd : part.getHeader("content-disposition").split(";")) {
      if (cd.trim().startsWith("filename")) {
        String filename = cd.substring(cd.indexOf('=') + 1).trim().replace("\"", "");
        return filename.substring(filename.lastIndexOf('/') + 1).substring(filename.lastIndexOf('\\') + 1); // MSIE fix.
      }
    }
    return null;
  }
%>
<%
  request.setCharacterEncoding("utf-8");
  response.setContentType("application/json");
  response.setStatus(200);

  boolean process = false;
  JSONArray jsonArr = new JSONArray();
  try {
    Collection<Part> parts = request.getParts();
    for (Part part : parts) {
      if (part.getHeader("Content-Disposition").contains("filename=")) {
        // 파일에 대한 처리
        JSONObject file = new JSONObject();
        String fileParam = part.getName();
	    	String id = fileParam.split("\\$", 2)[0];
	    	String col = fileParam.split("\\$", 2)[1];

        // 파일에 대한 write
        String filename = getFilename(part);
        // 파일이 저장될 서버의 디렉토리 경로
        String filepath = "/filedata/myPath/temp/";
        part.write(filepath + filename);

        file.put("id", id);
        file.put(col, filename);
        file.put(col + "Path", filepath);
        jsonArr.add(file);
      } else {
        // 다른 값에 대한 처리
        String colName = part.getName();
        String value = request.getParameter(part.getName());
      }
    }
    process = true;
  } catch (Exception ex) {
    System.out.println(ex.getMessage());
    process = false;
  }

  JSONObject result = new JSONObject();
  JSONObject IO = new JSONObject();
  try {
    int res = process ? 0 : -7; // -2 ~ -9까지 시트에 전달하면 오류 메시지를 띄웁니다.
    IO.put("Result", res);
    IO.put("data", jsonArr);

    // -1 브라우저 미지원 오류.
    result.put("IO", IO); // 통신 관련 객체
  } catch (Exception ex) {
    result.put("Exception", ex);
  }
  out.print(result);
%>
